DefineClass.sPart_SkylineOne_Antena = {
	__parents = { "BuildingEntityClass"},
	
	entity = "sPart_SkylineOne_Antena", 
	fx_actor_class = false,
}

DefineClass.sPart_SkylineOne_Apart = {
	__parents = { "BuildingEntityClass"},
	
	entity = "sPart_SkylineOne_Apart", 
}
DefineClass.sPart_SkylineOne_Entrance = {
	__parents = { "BuildingEntityClass"},
	
	entity = "sPart_SkylineOne_Entrance", 
}
DefineClass.sPart_SkylineOne_LastApart = {
	__parents = { "BuildingEntityClass"},
	
	entity = "sPart_SkylineOne_LastApart", 
}
DefineClass.sPart_SkylineOne_MidApart = {
	__parents = { "BuildingEntityClass"},
	
	entity = "sPart_SkylineOne_MidApart", 
}



-- Number of resident by stage
-- Tower :  30
-- Level 0 : 24
-- Level 1 : 16
-- Level 2 : 8
-- TOTAL : 78
DefineClass.sBuilding_SkylineOne = {
	__parents = { "SpireBase", "LivingBase", "Residence" },
	
	level_spots = {"Level1", "Level2", "Level3"},
	
	antena = false,
	stage_capacity_1 = 16,
	stage_capacity_2 = 8,
	
	fx_actor_class = false,
}


function sBuilding_SkylineOne:GameInit()

	-- self.upgrade1_icon = "UI/Icons/Upgrades/hygroscopic_coating_01.tga"
	-- self.upgrade2_icon = "UI/Icons/Upgrades/hygroscopic_coating_01.tga"
	-- self.upgrade3_icon = "UI/Icons/Upgrades/home_collective_01.tga"
	
	-- UnlockUpgrade(self.upgrade1_id) -- Level 1
	-- UnlockUpgrade(self.upgrade2_id) -- Level 2

	local att = self:GetAttaches("sPart_SkylineOne_Antena") or {}
	self.antena = att[1] or false
	
	self.fx_actor_class = "Apartments"
end

function sBuilding_SkylineOne:BuildingUpdate()
	self:ApplyHiveMindBonus()
end

function sBuilding_SkylineOne:WorkLightsOn()
	
	local SIModValue = 200
	self:SetSIModulation(SIModValue)
	
	local attaches = self:GetAttaches()
	
	for _, att in ipairs(attaches) do
		att:SetSIModulation(SIModValue)
	end
end

-- Notification Upgrades error
function sBuilding_SkylineOne:ConstructUpgrade(id)
	if UICity:IsUpgradeUnlocked(id) and not self:HasUpgrade(id) then
	
		if self:IsUpgradeBeingConstructed(id) then
			self:StopUpgradeConstruction(id)
		else
			if id == self.upgrade2_id then
				if self:HasUpgrade(self.upgrade1_id) then
					self:StartUpgradeConstruction(id)
				else
				-- Upgrade #1 needed
					AddCustomOnScreenNotification(
						"sSkylineOne_UpgradeError_Level2",
						T{407000,"Can't upgrade this building!"},
						T{407001,"You need to build Upgrade #1 before."},
						"UI/Icons/Notifications/milestone_complete_2.tga",
						function()end,
						{cycle_objs = {self}, close_on_read = true}
					)
				end
			else
				self:StartUpgradeConstruction(id)
			end
		end
	end
end

-- Change capacity
function sBuilding_SkylineOne:OnUpgradeToggled(upgrade_id, new_state)

	local stage_capacity = 0
	
	if upgrade_id == self.upgrade1_id then
		stage_capacity = self.stage_capacity_1
	end
	
	if upgrade_id == self.upgrade2_id then
		stage_capacity = self.stage_capacity_2
	end

	if new_state then
		self.capacity = self.capacity + stage_capacity
	else
	-- when upgrade is disabled : capacity down & remove residents
		local colonists, capacity = self.colonists, self.capacity
		local x,y,z = capacity, capacity - 1, capacity - 2
	  
		local slots = {x,y,z}
	
		for _, slot in ipairs(slots) do 
			if IsValid(colonists[slot]) then
				self:RemoveResident(colonists[slot]) 
			end
		end
	
		self.capacity = capacity - stage_capacity
	end

end

-- Add a new stage & up capacity
function sBuilding_SkylineOne:AddLevel(level)
	local stage = false
	local stage_capacity = 0
	
	if level == 1 then
		stage = PlaceObject("sPart_SkylineOne_MidApart")
		stage_capacity = self.stage_capacity_1
	else
		stage = PlaceObject("sPart_SkylineOne_LastApart")
		stage_capacity = self.stage_capacity_2
	end
	
	if  not stage then
		return
	end
	
	self:Attach(stage, self:GetSpotBeginIndex(self.level_spots[level]))
	self:Attach(self.antena, self:GetSpotBeginIndex(self.level_spots[level + 1]))
	
	self.capacity = self.capacity + stage_capacity
end


-- Adds stage when upgraded
function OnMsg.BuildingUpgraded(building, upgrade_id)
	if building:IsKindOf("sBuilding_SkylineOne") then 
		-- Level 1
		if upgrade_id == building.upgrade1_id then
			building:AddLevel(1)
			return
		end
		-- Level 2
		if upgrade_id == building.upgrade2_id then
			building:AddLevel(2)
			return
		end
	end
end

-- Hive Mind
function sBuilding_SkylineOne:GetHiveMindBonus()
	local traits = {}
	local trait_defs = TraitPresets
	for _, unit in ipairs(self.colonists) do
		for trait_id in pairs(unit.traits) do
			if trait_id ~= "none" then
				local trait_def = trait_defs[trait_id]
				local cat = trait_def and trait_def.group
				if cat == "Positive" or cat == "Specialization" then
					traits[trait_id] = true
				end
			end
		end
	end
	return table.count(traits)
end

function sBuilding_SkylineOne:ApplyHiveMindBonus()
	if not self.city:IsTechResearched("HiveMind") then
		return
	end
	local bonus = self:GetHiveMindBonus()
	local display_name = TechDef["HiveMind"].display_name
	for _, unit in ipairs(self.colonists) do
		unit:SetModifier("performance", "hive mind", bonus, 0, T{8570, "<green>Hive Mind <FormatSignInt(amount)></color>"})
	end
end

function sBuilding_SkylineOne:AddResident(unit)
	Residence.AddResident(self, unit)
	self:Notify("ApplyHiveMindBonus")
end

function sBuilding_SkylineOne:RemoveResident(unit)
	Residence.RemoveResident(self, unit)
	unit:SetModifier("performance", "hive mind", 0, 0)
	self:Notify("ApplyHiveMindBonus")
end